package ru.yandex.tikaite.mimeparser;

import java.io.IOException;

import org.apache.james.mime4j.MimeException;

import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.util.TextExtractOptions;

public class RootMessageHandler extends MessageHandler {
    private final DocumentCollectorFactory factory;
    private DocumentCollector collector = null;

    public RootMessageHandler(
        final MailMetaInfo meta,
        final TextExtractOptions options,
        final DocumentCollectorFactory factory)
    {
        super(meta, options);
        this.factory = factory;
    }

    @Override
    protected DocumentCollector collector() throws IOException {
        if (collector == null) {
            collector = factory.create(meta);
        }
        return collector;
    }

    @Override
    public void endMessage() throws MimeException {
        super.endMessage();
        if (collector != null) {
            try {
                collector.close();
            } catch (IOException e) {
                throw new MimeException("Failed to close collector", e);
            }
        }
    }
}

