package ru.yandex.tikaite.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.txt.UniversalEncodingDetector;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TxtParser extends AutoDetectionParser {
    public static final TxtParser INSTANCE = new TxtParser();

    private static final long serialVersionUID = 0;
    private static final int BUFFER_SIZE = 8192;

    private static final String P = "p";

    private static final List<EncodingDetector> DETECTOR =
        Collections.unmodifiableList(
            Arrays.asList(
                new UniversalEncodingDetector()));

    private static final TXTParser OLD_PARSER = new TXTParser();

    @Override
    public Set<MediaType> getSupportedTypes(final ParseContext context) {
        return OLD_PARSER.getSupportedTypes(context);
    }

    @Override
    public List<EncodingDetector> detectors() {
        return DETECTOR;
    }

    @Override
    public MediaType mediaType() {
        return MediaType.TEXT_PLAIN;
    }

    //CSOFF: ParameterNumber
    @Override
    public void parse(
        final InputStream is,
        final ContentHandler handler,
        final Metadata metadata,
        final ParseContext context)
        throws IOException, SAXException, TikaException
    {
        Reader reader = getReader(is, metadata);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.startElement(P);
        char[] buffer = new char[BUFFER_SIZE];
        int n = reader.read(buffer);
        while (n != -1) {
            xhtml.characters(buffer, 0, n);
            n = reader.read(buffer);
        }
        xhtml.endElement(P);
        xhtml.endDocument();
    }
    //CSON: ParameterNumber
}

