package ru.yandex.tikaite.parser.mp4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp4.MP4Parser;
import org.jcodec.common.logging.LogLevel;
import org.jcodec.common.logging.LogSink;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.logging.Message;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.MetaBox;
import org.jcodec.containers.mp4.boxes.MetaValue;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JcToolsMp4Parser extends MP4Parser {
    static {
        Logger.setLevel(LogLevel.ERROR);
        Logger.addSink(EmptySink.INSTANCE);
    }

    public static final JcToolsMp4Parser INSTANCE = new JcToolsMp4Parser();

    private static final long serialVersionUID = 0L;
    private static final Property MODEL = Property.internalText("Model");

    protected JcToolsMp4Parser() {
    }

    @Override
    public void parse(
        final InputStream stream,
        final ContentHandler contentHandler,
        final Metadata metadata,
        final ParseContext parseContext)
        throws IOException, SAXException, TikaException
    {
        try (TemporaryResources tmp = new TemporaryResources()) {
            TikaInputStream tstream = TikaInputStream.get(stream, tmp);
            super.parse(tstream, contentHandler, metadata, parseContext);

            if (metadata.get(Metadata.LATITUDE) == null && metadata.get(Metadata.LONGITUDE) == null) {
                MovieBox movieBox = MP4Util.parseMovie(tstream.getFile());
                MetaBox meta = NodeBox.findFirst(movieBox, MetaBox.class, "meta");
                if (meta != null) {
                    Map<String, MetaValue> map = meta.getKeyedMeta();
                    MetaValue coordinatesMeta = map.get("com.apple.quicktime.location.ISO6709");
                    if (coordinatesMeta != null) {
                        ISO6709Extractor.extract(coordinatesMeta.getString(), metadata);
                    } else {
                        coordinatesMeta = meta.getItunesMeta().get(1);
                        if (coordinatesMeta != null) {
                            ISO6709Extractor.extract(coordinatesMeta.getString(), metadata);
                        }
                    }

                    MetaValue modelMeta = map.get("com.apple.quicktime.model");
                    if (modelMeta != null) {
                        metadata.set(MODEL, modelMeta.getString());
                    }
                }
            }
        }
    }

    private static enum EmptySink implements LogSink {
        INSTANCE;

        @Override
        public void postMessage(final Message msg) {
        }
    }
}
