package ru.yandex.tikaite.server;

import java.io.IOException;

import org.apache.http.HttpConnection;

import ru.yandex.function.GenericAutoCloseable;

public class ConnectionTerminator
    implements GenericAutoCloseable<IOException>
{
    private HttpConnection conn;

    public ConnectionTerminator(final HttpConnection conn) {
        this.conn = conn;
    }

    @Override
    public void close() throws IOException {
        if (conn != null) {
            HttpConnection copy = this.conn;
            this.conn = null;
            copy.shutdown();
        }
    }
}

