package ru.yandex.tikaite.server;

import java.io.IOException;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.parser.uri.ScanningCgiParams;

public class NameSelectorHandler implements HttpRequestHandler {
    private final Map<String, HttpRequestHandler> handlers;

    public NameSelectorHandler(
        final Map<String, HttpRequestHandler> handlers)
    {
        this.handlers = handlers;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        String name = new ScanningCgiParams(request).getString("name");
        HttpRequestHandler handler = handlers.get(name);
        if (handler == null) {
            throw new MethodNotSupportedException(
                "No handler found for " + request);
        }
        handler.handle(request, response, context);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, HttpRequestHandler> en: handlers.entrySet()) {
            if (sb.length() != 0) {
                sb.append('\t');
                sb.append('\t');
            }
            sb.append("&name=");
            sb.append(en.getKey());
            sb.append('\t');
            sb.append(en.getValue());
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

