package ru.yandex.tikaite.util;

import java.io.IOException;

import org.apache.tika.io.TaggedIOException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.Parser;

import ru.yandex.function.GenericAutoCloseable;

public class DetectionResult implements GenericAutoCloseable<IOException> {
    private final TikaInputStream input;
    private final Parser parser;
    private final MediaType mediaType;

    public DetectionResult(
        final TikaInputStream input,
        final Parser parser,
        final MediaType mediaType)
    {
        this.input = input;
        this.parser = parser;
        this.mediaType = mediaType;
    }

    @Override
    public void close() throws IOException {
        input.close();
    }

    TikaInputStream input() {
        return input;
    }

    public MediaType mediaType() {
        return mediaType;
    }

    public Parser parser() {
        return parser;
    }

    public void throwIfCauseOf(final IOException e) throws IOException {
        input().throwIfCauseOf(e);
        if (e instanceof TaggedIOException) {
            throwIfCauseOf(((TaggedIOException) e).getCause());
        }
    }
}

