package ru.yandex.tikaite.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import ru.yandex.function.GenericAutoCloseable;

public class ExtractionFinalizer implements AutoCloseable {
    private final DetectionResult dr;
    private final GenericAutoCloseable<IOException> closeable;
    private final Logger logger;

    public ExtractionFinalizer(
        final DetectionResult dr,
        final GenericAutoCloseable<IOException> closeable,
        final Logger logger)
    {
        this.dr = dr;
        this.closeable = closeable;
        this.logger = logger;
    }

    public DetectionResult dr() {
        return dr;
    }

    public Logger logger() {
        return logger;
    }

    @Override
    public void close() {
        try {
            closeable.close();
        } catch (IOException e) {
            logger.log(Level.WARNING, "Failed to release resources", e);
        }
    }
}

