package ru.yandex.tikaite.util;

import org.apache.tika.sax.TeeContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class QuotesSeparatingContentHandler extends TeeContentHandler {
    private static final String BLOCKQUOTE = "blockquote";

    private final ContentHandler quotes;
    private final ContentHandler pure;
    private int blockquotes = 0;

    public QuotesSeparatingContentHandler(
        final ContentHandler quotes,
        final ContentHandler pure)
    {
        super(quotes, pure);
        this.quotes = quotes;
        this.pure = pure;
    }

    // CSOFF: ParameterNumber
    @Override
    public void startElement(
        final String uri,
        final String localName,
        final String qName,
        final Attributes attrs)
        throws SAXException
    {
        if (BLOCKQUOTE.equals(localName)) {
            ++blockquotes;
        }
        super.startElement(uri, localName, qName, attrs);
    }
    // CSON: ParameterNumber

    @Override
    public void endElement(
        final String uri,
        final String localName,
        final String qName)
        throws SAXException
    {
        if (BLOCKQUOTE.equals(localName)) {
            --blockquotes;
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(final char[] cbuf, final int off, final int len)
        throws SAXException
    {
        if (blockquotes == 0) {
            pure.characters(cbuf, off, len);
        } else {
            quotes.characters(cbuf, off, len);
        }
    }

    @Override
    public void ignorableWhitespace(
        final char[] cbuf,
        final int off,
        final int len)
        throws SAXException
    {
        if (blockquotes == 0) {
            pure.ignorableWhitespace(cbuf, off, len);
        } else {
            quotes.ignorableWhitespace(cbuf, off, len);
        }
    }
}

