package ru.yandex.tikaite.util;

import java.io.IOException;
import java.io.Writer;

public class QuotesSeparatingWriter extends Writer {
    private enum State {
        BEGIN, // begin of the line
        QUOTE,
        NON_QUOTE
    }

    private final Writer quotes;
    private final Writer pure;
    private State state = State.BEGIN;

    public QuotesSeparatingWriter(
        final Writer quotes,
        final Writer pure)
    {
        this.quotes = quotes;
        this.pure = pure;
    }

    @Override
    @SuppressWarnings("try")
    public void close() throws IOException {
        try (Writer quotes = this.quotes) {
            pure.close();
        }
    }

    @Override
    public void flush() throws IOException {
        quotes.flush();
        pure.flush();
    }

    @Override
    public void write(final int c) throws IOException {
        if (c == '\n') {
            if (state == State.QUOTE) {
                quotes.write('\n');
            } else {
                pure.write('\n');
            }
            state = State.BEGIN;
        } else {
            switch (state) {
                case BEGIN:
                    if (c == '>') {
                        state = State.QUOTE;
                    } else {
                        pure.write(c);
                        state = State.NON_QUOTE;
                    }
                    break;
                case NON_QUOTE:
                    pure.write(c);
                    break;
                default:
                    quotes.write(c);
                    break;
            }
        }
    }

    @Override
    public void write(final char[] cbuf, final int off, final int len)
        throws IOException
    {
        for (int i = 0; i < len; ++i) {
            write(cbuf[i + off]);
        }
    }
}

