package ru.yandex.tikaite.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;

import ru.yandex.function.GenericAutoCloseableChain;
import ru.yandex.io.GenericCloseableAdapter;
import ru.yandex.util.filesystem.CloseableDeleter;

public class TemporaryDirectory extends TemporaryResources {
    private final GenericAutoCloseableChain<IOException> resources =
        new GenericAutoCloseableChain<>();
    private final boolean temporaryFilesAllowed;
    private Path dir = null;
    private int cnt = 0;

    public TemporaryDirectory(final boolean temporaryFilesAllowed) {
        this.temporaryFilesAllowed = temporaryFilesAllowed;
    }

    @Override
    public void setTemporaryFileDirectory(final File tmpdir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Closeable> T getResource(final Class<T> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path createTempFile() throws IOException {
        if (temporaryFilesAllowed) {
            if (dir == null) {
                dir = Files.createTempDirectory("tikaite-");
                addResource(new CloseableDeleter(dir));
            }
            return Files.createFile(dir.resolve(Integer.toString(cnt++)));
        } else {
            throw new IOException("Temporary files is not allowed");
        }
    }

    @Override
    public void addResource(final Closeable resource) {
        resources.add(new GenericCloseableAdapter<>(resource));
    }

    @Override
    public void close() throws IOException {
        resources.close();
    }

    @Override
    public void dispose() throws TikaException {
        try {
            close();
        } catch (IOException e) {
            throw new TikaException("Failed to close temporary resources", e);
        }
    }
}

