package ru.yandex.tikaite.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;

import ru.yandex.url.processor.UrlInfo;

public class UrlCollector implements Consumer<UrlInfo> {
    private final Set<String> urls = new LinkedHashSet<>();

    @Override
    public void accept(final UrlInfo urlInfo) {
        String url = urlInfo.url().toString(true);
        if (url.indexOf("://") != -1) {
            urls.add(url);
        }
    }

    public Set<String> urls() {
        return Collections.unmodifiableSet(urls);
    }
}

