package ru.yandex.tikaite.util;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import ru.yandex.parser.html.FilterContentHandler;
import ru.yandex.url.processor.UrlProcessor;

public class UrlHandler extends FilterContentHandler {
    private final UrlProcessor processor;
    private int textLen = 0;

    public UrlHandler(
        final ContentHandler handler,
        final UrlProcessor processor)
    {
        super(handler);
        this.processor = processor;
    }

    private void barrier() {
        if (textLen > 0) {
            if (textLen >= 4) { // t.co
                processor.process();
            } else {
                processor.reset();
            }
            textLen = 0;
        }
    }

    // CSOFF: ParameterNumber
    @Override
    public void startElement(
        final String uri,
        final String localName,
        final String qName,
        final Attributes attrs)
        throws SAXException
    {
        barrier();
        if (localName.equalsIgnoreCase("a")
            || localName.equalsIgnoreCase("area"))
        {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                if (attrs.getLocalName(i).equalsIgnoreCase("href")) {
                    processor.process(attrs.getValue(i).toCharArray());
                    processor.process();
                }
            }
        }
        super.startElement(uri, localName, qName, attrs);
    }
    // CSON: ParameterNumber

    @Override
    public void endElement(
        final String uri,
        final String localName,
        final String qName)
        throws SAXException
    {
        barrier();
        super.endElement(uri, localName, qName);
    }

    @Override
    public void characters(final char[] cbuf, final int off, final int len)
        throws SAXException
    {
        if (len > 0) {
            processor.process(cbuf, off, len);
            textLen += len;
        }
        super.characters(cbuf, off, len);
    }

    @Override
    public void ignorableWhitespace(
        final char[] cbuf,
        final int off,
        final int len)
        throws SAXException
    {
        barrier();
        super.ignorableWhitespace(cbuf, off, len);
    }

    @Override
    public void processingInstruction(final String target, final String data)
        throws SAXException
    {
        barrier();
        super.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(final String name) throws SAXException {
        barrier();
        super.skippedEntity(name);
    }

    @Override
    public void endDocument() throws SAXException {
        barrier();
        super.endDocument();
    }
}

