package ru.yandex.tskv;

import java.io.IOException;
import java.io.Reader;

public abstract class AbstractInplaceTskvParser<T extends TskvRecord>
    extends TskvParser<T>
{
    protected T record;

    protected AbstractInplaceTskvParser() {
        super(null);
    }

    protected AbstractInplaceTskvParser(final TskvFormatConfig config) {
        super(null, config);
    }

    public T next(final Reader reader)
        throws IOException, TskvException, NumberFormatException
    {
        this.record = null;
        parseWithException(reader);
        return record;
    }

    @Override
    protected boolean handle(
        final T record)
        throws TskvException
    {
        this.record = record;
        return false;
    }
}
