package ru.yandex.tskv;

public class ImmutableTskvFormatConfig implements TskvFormatConfig {
    private final char recordSeparator;
    private final char keyValueSeparator;
    private final char fieldSeparator;
    private final String linePrefix;
    private final boolean enableEscaping;
    private final boolean escapeCarriageReturn;
    private final char escapingSymbol;
    private final boolean enableTableIndex;
    private final String tableIndexColumn;

    public ImmutableTskvFormatConfig(final TskvFormatConfig config) {
        this.recordSeparator = config.recordSeparator();
        this.keyValueSeparator = config.keyValueSeparator();
        this.fieldSeparator = config.fieldSeparator();
        this.linePrefix = config.linePrefix();
        this.enableEscaping = config.escapingEnabled();
        this.escapeCarriageReturn = config.escapeCarriageReturn();
        this.escapingSymbol = config.escapingSymbol();
        this.enableTableIndex = config.tableIndexEnabled();
        this.tableIndexColumn = config.tableIndexColumn();
    }

    public ImmutableTskvFormatConfig() {
        this(new TskvFormatConfigBuilder());
    }

    @Override
    public char recordSeparator() {
        return recordSeparator;
    }

    @Override
    public char keyValueSeparator() {
        return keyValueSeparator;
    }

    @Override
    public char fieldSeparator() {
        return fieldSeparator;
    }

    @Override
    public String linePrefix() {
        return linePrefix;
    }

    @Override
    public boolean escapingEnabled() {
        return enableEscaping;
    }

    @Override
    public boolean escapeCarriageReturn() {
        return escapeCarriageReturn;
    }

    @Override
    public char escapingSymbol() {
        return escapingSymbol;
    }

    @Override
    public boolean tableIndexEnabled() {
        return enableTableIndex;
    }

    @Override
    public String tableIndexColumn() {
        return tableIndexColumn;
    }
}
