package ru.yandex.tskv;

import java.util.ArrayList;
import java.util.List;

public class ListTskvHandler extends AbstractTskvHandler<TskvRecord> {
    private final List<TskvRecord> records;

    public ListTskvHandler() {
        this.records = new ArrayList<>();
    }

    public ListTskvHandler(final int size) {
        this.records = new ArrayList<>(size);
    }

    @Override
    public boolean onRecord(final TskvRecord record) {
        records.add(record);
        return true;
    }

    public List<TskvRecord> records() {
        return records;
    }

    public void clear() {
        records.clear();
    }
}
