package ru.yandex.tskv;

import java.util.logging.Logger;

import ru.yandex.logger.HandlersManager;
import ru.yandex.logger.ImmutableLoggerConfig;
import ru.yandex.logger.LoggerConfig;
import ru.yandex.parser.config.ConfigException;

public class MockImmutableLoggerConfig extends ImmutableLoggerConfig {
    private static final int HASH_CODE_CONST = 31;
    private final MockLogger logger;

    public MockImmutableLoggerConfig(
        final LoggerConfig config) throws ConfigException
    {
        super(config);
        logger = new MockLogger();
    }

    @Override
    public Logger build(
        final HandlersManager handlersManager) throws ConfigException
    {
        logger.addHandler(
            handlersManager.handler(
                this,
                this.files().values().iterator().next()));
        logger.setLevel(logLevel());
        logger.setUseParentHandlers(false);
        return logger;
    }

    public MockLogger logger() {
        return logger;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MockImmutableLoggerConfig)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }

        MockImmutableLoggerConfig that = (MockImmutableLoggerConfig) o;

        return logger.equals(that.logger);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = HASH_CODE_CONST * result + logger.hashCode();
        return result;
    }
}
