package ru.yandex.tskv;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MockLogger extends Logger {
    private final List<String> out = new ArrayList<>();

    public MockLogger() {
        this("mock", null);
        this.setLevel(Level.ALL);
    }

    public MockLogger(final String name, final String resourceBundleName) {
        super(name, resourceBundleName);
    }

    @Override
    public void log(final LogRecord record) {
        out.add(record.getMessage());
    }

    public List<String> output() {
        return out;
    }

    public void clear() {
        this.output().clear();
    }
}
