package ru.yandex.tskv;

import java.util.logging.Logger;

public abstract class PrefixedTskvLogger<T extends TskvLogger>
    extends TskvLogger
{
    protected PrefixedTskvLogger(final Logger logger) {
        super(logger);
    }

    protected PrefixedTskvLogger(
        final Logger logger,
        final TskvFormatConfig config)
    {
        super(logger, config);
    }

    protected abstract T create(
        final Logger logger,
        final TskvFormatConfig config);

    public T prefix(final TskvString record) {
        TskvFormatConfigBuilder builder = new TskvFormatConfigBuilder(config);
        builder.linePrefix(record.toString());
        return create(logger, builder);
    }

    public T prefix(final String... pairs) {
        return prefix(record().append(pairs));
    }
}
