package ru.yandex.tskv;

import java.io.CharArrayReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.nio.IOControl;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.AsyncCharConsumer;

public class TskvAsyncConsumer
    extends AsyncCharConsumer<List<TskvRecord>>
    implements TskvHandler<TskvRecord>
{
    private final TskvParser<TskvRecord> parser;
    private final List<TskvRecord> records;
    private volatile TskvException suppressed = null;

    public TskvAsyncConsumer(final HttpEntity entity) throws HttpException {
        super(entity);

        parser = new BasicTskvParser(this);
        records = new ArrayList<>();
    }

    @Override
    protected void consumeContent(
        final CharBuffer buf,
        final IOControl ioctrl)
        throws IOException
    {
        try {
            parser.process(
                new CharArrayReader(
                    buf.array(),
                    buf.arrayOffset(),
                    buf.remaining()));
        } catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean onRecord(final TskvRecord record) {
        records.add(record);
        return true;
    }

    @Override
    public boolean onError(final TskvException exc) {
        suppressed = exc;
        return false;
    }

    @Override
    protected List<TskvRecord> buildResult(
        final HttpContext context)
        throws Exception
    {
        if (suppressed != null) {
            throw suppressed;
        }
        parser.eof();

        return records;
    }
}
