package ru.yandex.tskv;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class TskvAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<TskvRecord>>
{
    public static final TskvAsyncConsumerFactory INSTANCE =
        new TskvAsyncConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<
        List<TskvRecord>> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected TskvAsyncConsumerFactory() {
    }

    @Override
    public TskvAsyncConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new TskvAsyncConsumer(response.getEntity());
    }
}
