package ru.yandex.tskv;

public final class TskvFormat {
    static final int LENGTH = 100;
    static final boolean[] KEY_NEED_ESCAPE = new boolean[LENGTH];
    static final boolean[] VALUE_NEED_ESCAPE = new boolean[LENGTH];

    static {
        KEY_NEED_ESCAPE['='] = true;
        KEY_NEED_ESCAPE['\\'] = true;
        KEY_NEED_ESCAPE['\t'] = true;
        KEY_NEED_ESCAPE['\n'] = true;
        KEY_NEED_ESCAPE['\0'] = true;
        KEY_NEED_ESCAPE['\r'] = true;
        VALUE_NEED_ESCAPE['\\'] = true;
        VALUE_NEED_ESCAPE['\t'] = true;
        VALUE_NEED_ESCAPE['\n'] = true;
        VALUE_NEED_ESCAPE['\0'] = true;
        VALUE_NEED_ESCAPE['\r'] = true;
    }

    private TskvFormat() {
    }

    public static boolean keyEscape(final int c) {
        if (c < KEY_NEED_ESCAPE.length) {
            return KEY_NEED_ESCAPE[c];
        }

        return false;
    }

    public static boolean valueEscape(final int c) {
        if (c < VALUE_NEED_ESCAPE.length) {
            return VALUE_NEED_ESCAPE[c];
        }

        return false;
    }
}
