package ru.yandex.tskv;

/**
 * Tskv (alson known as DSV) format properties
 * https://wiki.yandex-team.ru/yt/userdoc/formats/#dsv
 */
public interface TskvFormatConfig {
    /**
     * разделитель записей
     */
    char recordSeparator();

    /**
     * разделитель пары ключ-значение
     */
    char keyValueSeparator();

    /**
     * разделитель полей в записи
     */
    char fieldSeparator();

    /**
     * обязательная колонка в начале каждой записи
     */
    String linePrefix();

    /**
     * включен ли escaping записей
     */
    boolean escapingEnabled();

    /**
     * включен ли escaping символа '\r'
     */
    boolean escapeCarriageReturn();

    /**
     * символ экранирования
     */
    char escapingSymbol();

    /**
     * включен ли вывод индекса входной таблицы
     */
    boolean tableIndexEnabled();

    /**
     * название колонки, в которой будет лежать индекс таблицы
     */
    String tableIndexColumn();
}
