package ru.yandex.tskv;

public class TskvFormatConfigBuilder implements TskvFormatConfig {
    private char recordSeparator = '\n';
    private char keyValueSeparator = '=';
    private char fieldSeparator = '\t';
    private String linePrefix = "tskv";
    private boolean enableEscaping = true;
    private boolean escapeCarriageReturn = false;
    private char escapingSymbol = '\\';
    private boolean enableTableIndex = false;
    private String tableIndexColumn = null;

    public TskvFormatConfigBuilder() {
    }

    public TskvFormatConfigBuilder(final TskvFormatConfig config) {
        this.recordSeparator = config.recordSeparator();
        this.keyValueSeparator = config.keyValueSeparator();
        this.fieldSeparator = config.fieldSeparator();
        this.linePrefix = config.linePrefix();
        this.enableEscaping = config.escapingEnabled();
        this.escapeCarriageReturn = config.escapeCarriageReturn();
        this.escapingSymbol = config.escapingSymbol();
        this.enableTableIndex = config.tableIndexEnabled();
        this.tableIndexColumn = config.tableIndexColumn();
    }

    @Override
    public char recordSeparator() {
        return recordSeparator;
    }

    public TskvFormatConfigBuilder recordSeparator(
        final char recordSeparator)
    {
        this.recordSeparator = recordSeparator;
        return this;
    }

    @Override
    public char keyValueSeparator() {
        return keyValueSeparator;
    }

    public TskvFormatConfigBuilder keyValueSeparator(
        final char keyValueSeparator)
    {
        this.keyValueSeparator = keyValueSeparator;
        return this;
    }

    @Override
    public char fieldSeparator() {
        return fieldSeparator;
    }

    public TskvFormatConfigBuilder fieldSeparator(
        final char fieldSeparator)
    {
        this.fieldSeparator = fieldSeparator;
        return this;
    }

    @Override
    public String linePrefix() {
        return linePrefix;
    }

    public TskvFormatConfigBuilder linePrefix(
        final String linePrefix)
    {
        this.linePrefix = linePrefix;
        return this;
    }

    @Override
    public boolean escapingEnabled() {
        return enableEscaping;
    }

    public TskvFormatConfigBuilder enableEscaping(
        final boolean enableEscaping)
    {
        this.enableEscaping = enableEscaping;
        return this;
    }

    @Override
    public boolean escapeCarriageReturn() {
        return escapeCarriageReturn;
    }

    public TskvFormatConfigBuilder escapeCarriageReturn(
        final boolean escapeCarriageReturn)
    {
        this.escapeCarriageReturn = escapeCarriageReturn;
        return this;
    }

    @Override
    public char escapingSymbol() {
        return escapingSymbol;
    }

    public TskvFormatConfigBuilder escapingSymbol(
        final char escapingSymbol)
    {
        this.escapingSymbol = escapingSymbol;
        return this;
    }

    @Override
    public boolean tableIndexEnabled() {
        return enableTableIndex;
    }

    public TskvFormatConfigBuilder enableTableIndex(
        final boolean enableTableIndex)
    {
        this.enableTableIndex = enableTableIndex;
        return this;
    }

    @Override
    public String tableIndexColumn() {
        return tableIndexColumn;
    }

    public TskvFormatConfigBuilder tableIndexColumn(
        final String tableIndexColumn)
    {
        this.tableIndexColumn = tableIndexColumn;
        return this;
    }
}
