package ru.yandex.tskv;

import java.util.logging.Level;
import java.util.logging.Logger;

public class TskvLogger {
    protected final Logger logger;
    protected TskvFormatConfig config;

    public TskvLogger(final Logger logger) {
        this(logger, new ImmutableTskvFormatConfig());
    }

    public TskvLogger(
        final Logger logger,
        final TskvFormatConfig config)
    {
        this.logger = logger;
        this.config = config;
    }

    public void log(final Level level, final TskvString record) {
        logger.log(level, record.toString());
    }

    public void log(final TskvString record) {
        log(Level.ALL, record);
    }

    public void log(final String... pairs) {
        log(Level.ALL, pairs);
    }

    public void log(final Level level, final String... pairs) {
        log(level, record().append(pairs));
    }

    public void info(final TskvString record) {
        log(Level.INFO, record);
    }

    public void info(final String... pairs) {
        log(Level.INFO, pairs);
    }

    public void fine(final TskvString record) {
        log(Level.FINE, record);
    }

    public void fine(final String... pairs) {
        log(Level.FINE, pairs);
    }

    public void severe(final TskvString record) {
        log(Level.SEVERE, record);
    }

    public void severe(final String... pairs) {
        log(Level.SEVERE, pairs);
    }

    public TskvString record() {
        return new TskvString(config);
    }

    public Logger logger() {
        return logger;
    }
}
