package ru.yandex.tskv;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.ValuesStorage;

public class TskvRecord
    extends LinkedHashMap<String, String>
    implements ValuesStorage<TskvException>
{
    private static final long serialVersionUID = -7862295268420722926L;
    private static final CollectionParser<String, List<String>, Exception>
        PARSER =
            new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new);

    public TskvRecord(final int initialCapacity, final float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TskvRecord(final int initialCapacity) {
        super(initialCapacity);
    }

    public TskvRecord() {
    }

    public TskvRecord(
        final Map<? extends String, ? extends String> m)
    {
        super(m);
    }

    public TskvRecord(
        final int initialCapacity,
        final float loadFactor,
        final boolean accessOrder)
    {
        super(initialCapacity, loadFactor, accessOrder);
    }

    public TskvString toOutput() {
        TskvString record = new TskvString();

        for (Map.Entry<String, String> entry: entrySet()) {
            record.append(entry.getKey(), entry.getValue());
        }

        return record;
    }

    @Override
    public String toString() {
        return toOutput().toString();
    }

    public static TskvRecord fromString(final String s) throws TskvException {
        FirstTskvRecordHandler handler = new FirstTskvRecordHandler();
        try {
            new BasicTskvParser(handler).parse(new StringReader(s));
        } catch (final IOException e) {
            throw new TskvException(
                new StringBuilder("IOException"), null, e.getMessage());
        }

        return handler.record();
    }

    public void put(final String key, final int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(final String key, final long value) {
        this.put(key, String.valueOf(value));
    }

    public void put(final String key, final double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public TskvException parameterNotSetException(final String name) {
        return new TskvException("No field with name " + name);
    }

    @Override
    public TskvException parseFailedException(
        final String name,
        final String value,
        final Throwable cause)
    {
        return new TskvException(
            "Parse failed for field " + name + " with value " + value,
            cause);
    }

    @Override
    public String getOrNull(final String name) {
        return get(name);
    }

    @Override
    public String getLastOrNull(final String name) {
        return get(name);
    }

    @Override
    public Iterator<String> getAllOrNull(final String name) {
        String value = getOrNull(name);
        if (value == null) {
            return null;
        }

        try {
            return PARSER.apply(value).iterator();
        } catch (Exception e) {
            return null;
        }
    }
}
