package ru.yandex.tskv;

import java.io.CharArrayReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.function.Function;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.nio.IOControl;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.nio.AsyncCharConsumer;

public class TskvStreamAsyncConsumer
    extends AsyncCharConsumer<Void>
    implements TskvHandler<TskvRecord>
{
    private final Function<TskvRecord, Boolean> consumer;
    private final TskvParser<TskvRecord> parser;

    private volatile TskvException suppressed = null;
    private volatile boolean skipping = false;

    public TskvStreamAsyncConsumer(
        final HttpEntity entity,
        final Function<TskvRecord, Boolean> consumer)
        throws HttpException
    {
        super(entity);

        this.parser = new BasicTskvParser(this);

        this.consumer = consumer;
    }

    @Override
    protected void consumeContent(
        final CharBuffer buf,
        final IOControl ioctrl)
        throws IOException
    {
        try {
            if (!skipping) {
                parser.process(
                    new CharArrayReader(
                        buf.array(),
                        buf.arrayOffset(),
                        buf.remaining()));
            }
        } catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean onRecord(final TskvRecord record) {
        if (!skipping) {
            skipping = consumer.apply(record);
        }

        return !skipping;
    }

    @Override
    public boolean onError(final TskvException exc) {
        suppressed = exc;
        return false;
    }

    @Override
    protected Void buildResult(
        final HttpContext context)
        throws Exception
    {
        parser.eof();
        if (suppressed != null) {
            throw suppressed;
        }

        return null;
    }
}
