package ru.yandex.tskv;

import java.io.IOException;
import java.util.function.Function;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class TskvStreamAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Void>
{
    private final Function<TskvRecord, Boolean> consumer;

    public TskvStreamAsyncConsumerFactory(
        final Function<TskvRecord, Boolean> consumer)
    {
        this.consumer = consumer;
    }

    @Override
    public HttpAsyncResponseConsumer<Void> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new TskvStreamAsyncConsumer(
            response.getEntity(),
            consumer);
    }
}
