package ru.yandex.tskv;

import java.io.IOException;

import ru.yandex.io.StringBuilderWriter;

public class TskvString extends TskvWriter {
    public TskvString(final TskvFormatConfig config) {
        super(new StringBuilderWriter(), config);
    }

    public TskvString(final TskvFormatConfig config, final String prefix) {
        super(new StringBuilderWriter(), config, prefix);
    }

    public TskvString() {
        this(new ImmutableTskvFormatConfig());
    }

    public TskvString(final TskvFormatConfig config, final TskvString prefix) {
        this(config, prefix.toString());
    }

    public TskvString append(final String key, final String value) {
        try {
            write(key, value);
        } catch (IOException ioe) {
        }

        return this;
    }

    public TskvString append(final String key, final int value) {
        return append(key, String.valueOf(value));
    }

    public TskvString append(final String key, final boolean value) {
        return append(key, String.valueOf(value));
    }

    public TskvString append(final String key, final long value) {
        return append(key, String.valueOf(value));
    }

    public TskvString append(final String key, final double value) {
        return append(key, String.valueOf(value));
    }

    public TskvString append(final String... pairs) {
        try {
            this.write(pairs);
        } catch (IOException ioe) {
        }

        return this;
    }

    @Override
    public String toString() {
        return writer().toString();
    }
}
