#include <mail/library/utf8/utf8.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

using namespace NUtil;


TEST(NUtilUtf8, Utf8ToLower) {
    EXPECT_EQ(Utf8ToLower("MiXeD"), "mixed");
    EXPECT_EQ(Utf8ToLower("ИзВиНиТе зА нЕрОвНыЙ пОчЕрК"), "извините за неровный почерк");
    EXPECT_EQ(Utf8ToLower("КаКой-То не\x81валидный uTf8"), "какой-то невалидный utf8");
}

TEST(NUtilUtf8, Utf8Trim) {
    EXPECT_EQ(Utf8Trim("   test  тест"), "test  тест");
    EXPECT_EQ(Utf8Trim("test  тест   "), "test  тест");
    EXPECT_EQ(Utf8Trim("   test  тест   "), "test  тест");
    EXPECT_EQ(Utf8Trim("      "), "");
    EXPECT_EQ(Utf8Trim(""), "");
    EXPECT_EQ(Utf8Trim("\x81  \x82 "), "");
}

TEST(NUtilUtf8, Utf8Unquote) {
    EXPECT_EQ(Utf8Unquote("test"), "test");
    EXPECT_EQ(Utf8Unquote("\"test\""), "test");
    EXPECT_EQ(Utf8Unquote(" \t \"test\""), "test");
    EXPECT_EQ(Utf8Unquote("\"test\" \t "), "test");
    EXPECT_EQ(Utf8Unquote(" \t \"test\" \t "), "test");
    EXPECT_EQ(Utf8Unquote("\"test"), "\"test");
    EXPECT_EQ(Utf8Unquote("test\"test"), "test\"test");
}

TEST(NUtilUtf8, Utf8Backslash) {
    EXPECT_EQ(Utf8Backslash("test"), "test");
    EXPECT_EQ(Utf8Backslash("\"test\""), "\\\"test\\\"");
    EXPECT_EQ(Utf8Backslash("te\\st"), "te\\\\st");
    EXPECT_EQ(Utf8Backslash("te\tst", L"", true), "te\\tst");
}

TEST(NUtilUtf8, Utf8Sanitized) {
    EXPECT_EQ(Utf8Sanitized("testтестtest"), "testтестtest");
    EXPECT_EQ(Utf8Sanitized("testте\xB4тtest"), "testтетtest");
    EXPECT_EQ(Utf8Sanitized("\xB4еstте\xB4тtest"), "еstтетtest");

    EXPECT_EQ(Utf8Sanitized("Wtrlt: \xED\xA0\xBD\xED\xB3\x9A Mittwoch"), "Wtrlt:  Mittwoch");
}

TEST(NUtilUtf8, Utf8ByteHead) {
    EXPECT_EQ(Utf8ByteHead("Строка", 0), "");
    EXPECT_EQ(Utf8ByteHead("Строка", 6), "Стр");
    EXPECT_EQ(Utf8ByteHead("Строка", 7), "Стр");
    EXPECT_EQ(Utf8ByteHead("Строка", 8), "Стро");
    EXPECT_EQ(Utf8ByteHead("String", 3), "Str");
    EXPECT_EQ(Utf8ByteHead("Сtрока", 7), "Сtро");

    // Garbage in - garbage out
    EXPECT_EQ(Utf8ByteHead("С\xFFт\xFFр\xFFо\xFFк\xFFа", 7), "С\xFFт\xFF");
    EXPECT_EQ(Utf8ByteHead("\x80\x80", 1), "\x80\x80");
}

