#pragma once

#include <locale>
#include <string>

namespace NUtil {

std::string Utf8Sanitized(const std::string& val);

std::string Utf8Unquote(const std::string& val);

std::string Utf8Backslash(
    const std::string& val,
    const std::wstring& toEscape = L"\"\\",
    bool escapeControl = false);

std::string Utf8Trim(const std::string& val);

std::string Utf8ToLower(const std::string& val);

std::string Utf8ByteHead(const std::string& val, size_t count);

const std::locale& GetDefaultUtfLocale();

} // namespace NUtil
