package ru.yandex.xml.xpath;

import java.util.Arrays;

import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XPathContentHandler extends XPathContentHandlerBase {
    private static final int INITIAL_CAPACITY = 16;

    private final XPathLeafHandler handler;
    private StringBuilder[] texts = new StringBuilder[INITIAL_CAPACITY];

    public XPathContentHandler(final XPathLeafHandler handler) {
        this.handler = handler;
    }

    private void ensureCapacity() {
        if (size == texts.length) {
            texts = Arrays.copyOf(texts, size << 1);
        }
    }

    @Override
    public void characters(final char[] buf, final int off, final int len)
        throws SAXException
    {
        texts[size - 1].append(buf, off, len);
    }

    @Override
    public void endElement(
        final String uri,
        final String localName,
        final String qName)
        throws SAXException
    {
        StringBuilder sb = texts[size - 1];
        String text;
        if (sb.length() == 0) {
            text = "";
        } else {
            text = new String(sb);
        }
        handler.handle(this, text);
        super.endElement(uri, localName, qName);
    }

    @Override
    public void endPrefixMapping(final String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(
        final char[] buf,
        final int off,
        final int len)
    {
    }

    @Override
    public void processingInstruction(final String target, final String data)
        throws SAXException
    {
    }

    @Override
    public void setDocumentLocator(final Locator locator) {
    }

    @Override
    public void skippedEntity(final String name) throws SAXException {
    }

    // CSOFF: ParameterNumber
    @Override
    public void startElement(
        final String uri,
        final String localName,
        final String qName,
        final Attributes atts)
        throws SAXException
    {
        ensureCapacity();
        StringBuilder text = texts[size];
        if (text == null) {
            texts[size] = new StringBuilder();
        } else {
            text.setLength(0);
        }
        super.startElement(uri, localName, qName, atts);
    }
    // CSON: ParameterNumber

    @Override
    public void startPrefixMapping(final String prefix, final String uri)
        throws SAXException
    {
    }
}

