package ru.yandex.xml.xpath;

import java.util.AbstractList;
import java.util.Arrays;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class XPathContentHandlerBase
    extends AbstractList<String>
    implements ContentHandler
{
    private static final int INITIAL_CAPACITY = 16;

    protected String[] path = new String[INITIAL_CAPACITY];
    protected int size = 0;

    private void ensureCapacity() {
        if (size == path.length) {
            path = Arrays.copyOf(path, size << 1);
        }
    }

    // List implementation
    @Override
    public int size() {
        return size;
    }

    @Override
    public String get(final int i) {
        if (i >= size) {
            throw new IndexOutOfBoundsException(i + " >= " + size);
        }
        return path[i];
    }

    // ContentHandler implementation
    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(
        final String uri,
        final String localName,
        final String qName)
        throws SAXException
    {
        --size;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    // CSOFF: ParameterNumber
    @Override
    public void startElement(
        final String uri,
        final String localName,
        final String qName,
        final Attributes atts)
        throws SAXException
    {
        ensureCapacity();
        path[size++] = localName;
    }
    // CSON: ParameterNumber
}

