package ru.yandex.search.mail.yt.consumer;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class JobListHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final YtConsumer ytConsumer;

    public JobListHandler(final YtConsumer ytConsumer) {
        this.ytConsumer = ytConsumer;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        BasicProxySession session =
            new BasicProxySession(ytConsumer, exchange, context);
        StringBuilderWriter sbw = new StringBuilderWriter();
        JsonType jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
        SourceConsumerFactory consumer =
            session.params().getEnum(SourceConsumerFactory.class, "consumer");
        try (JsonWriter jw = jsonType.create(sbw)) {
            jw.value(ytConsumer.scheduler(consumer).jobs());
        }
    }
}
