package ru.yandex.search.mail.yt.consumer;

import java.io.BufferedReader;
import java.io.IOException;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.search.mail.yt.consumer.yt.RecordConsumer;

public class JsonFormatReader implements GenericAutoCloseable<IOException> {
    private final BufferedReader reader;
    private final RecordConsumer<JsonObject> recordConsumer;
    private volatile boolean finished = false;

    public JsonFormatReader(
        final BufferedReader reader,
        final RecordConsumer<JsonObject> consumer)
    {
        this.reader = reader;
        this.recordConsumer = consumer;
    }

    public void read() throws IOException {
        BasicGenericConsumer<JsonObject, JsonException> consumer =
            new BasicGenericConsumer<>();
        JsonParser parser = TypesafeValueContentHandler.prepareParser(consumer);
        String line;
        try {
            recordConsumer.start();
            while ((line = reader.readLine()) != null) {
                if (!line.trim().isEmpty()) {
                    char[] buffer = line.toCharArray();
                    parser.process(buffer, 0, buffer.length);
                    parser =
                        TypesafeValueContentHandler.prepareParser(consumer);

                    JsonObject record = consumer.get();
                    if (record != null) {
                        if (!recordConsumer.onRecord(record)) {
                            return;
                        }
                        consumer.accept(null);
                        parser =
                            TypesafeValueContentHandler.prepareParser(consumer);
                    }
                }
            }

            JsonObject record = consumer.get();
            if (record != null) {
                recordConsumer.onRecord(record);
            }
        } catch (JsonException | NumberFormatException je) {
            recordConsumer.onRecord(JsonMap.EMPTY);
            je.printStackTrace();
        } finally {
            close();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!finished) {
            recordConsumer.end();
            finished = true;
            reader.close();
        }
    }
}
