package ru.yandex.search.mail.yt.consumer;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.function.Function;
import java.util.function.LongFunction;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.nio.IOControl;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericConsumer;
import ru.yandex.http.util.nio.AsyncCharConsumer;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StringCollectors;

public class JsonStreamAsyncConsumer
    extends AsyncCharConsumer<Void>
    implements GenericConsumer<JsonObject, JsonException>
{
    private final JsonParser parser;
    private final Function<JsonObject, Boolean> consumer;
    private volatile boolean skipping = false;

    // CSOFF: ParameterNumber
    protected JsonStreamAsyncConsumer(
        final HttpEntity entity,
        final Function<JsonObject, Boolean> consumer,
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory)
        throws HttpException
    {
        super(entity);

        this.consumer = consumer;
        parser = new JsonParser(
            new StackContentHandler(
                new TypesafeValueContentHandler(
                    this,
                    stringCollectorsFactory.apply(contentLength(entity)),
                    containerFactory)),
            true);
    }
    // CSON: ParameterNumber

    @Override
    protected void consumeContent(
        final CharBuffer buf,
        final IOControl ioctrl)
        throws IOException
    {
        try {
            parser.process(buf.array(), buf.arrayOffset(), buf.remaining());
        } catch (Throwable t) {
            if (skipping) {
                return;
            } else {
                throw new IOException(t);
            }
        }
    }

    @Override
    public void accept(final JsonObject json) throws JsonException {
        if (!skipping) {
            skipping = consumer.apply(json);
        }
    }

    @Override
    protected Void buildResult(final HttpContext context) throws Exception {
        parser.eof();
        return null;
    }
}
