package ru.yandex.search.mail.yt.consumer;

import java.io.IOException;
import java.util.function.Function;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public class JsonStreamAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Void>
{
    private final Function<JsonObject, Boolean> consumer;

    public JsonStreamAsyncConsumerFactory(
        final Function<JsonObject, Boolean> consumer)
    {
        this.consumer = consumer;
    }

    @Override
    public HttpAsyncResponseConsumer<Void> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new JsonStreamAsyncConsumer(
            response.getEntity(),
            consumer,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }
}
