package ru.yandex.search.mail.yt.consumer;

import java.io.IOException;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.mail.yt.consumer.scheduler.Scheduler;
import ru.yandex.search.mail.yt.consumer.scheduler.SchedulerLock;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class SchedulerMasterCheckHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final YtConsumer ytConsumer;
    private final Map<SourceConsumerFactory, Scheduler> schedulers;

    public SchedulerMasterCheckHandler(
        final YtConsumer ytConsumer,
        final Map<SourceConsumerFactory, Scheduler> schedulers)
    {
        this.ytConsumer = ytConsumer;
        this.schedulers = schedulers;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        ProxySession session =
            new BasicProxySession(ytConsumer, exchange, context);
        SourceConsumerFactory consumer =
            session.params().getEnum(SourceConsumerFactory.class, "consumer");

        Scheduler scheduler = schedulers.get(consumer);
        if (scheduler == null) {
            throw new NotFoundException(
                "Source consumer not found " + consumer.name());
        }

        SchedulerLock lock = scheduler.getMaster();
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = JsonType.HUMAN_READABLE.create(sbw)) {
            lock.writeValue(jw);
        }

        session.response(HttpStatus.SC_OK, sbw.toString());
    }
}
