package ru.yandex.search.mail.yt.consumer;

import java.io.IOException;
import java.util.Map;

import org.apache.http.HttpHost;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.mail.yt.consumer.config.ImmutableSourceConsumerConfig;
import ru.yandex.search.mail.yt.consumer.config.ImmutableWorkersConfig;
import ru.yandex.search.mail.yt.consumer.scheduler.Scheduler;
import ru.yandex.search.mail.yt.consumer.upload.UploaderFactory;
import ru.yandex.stater.Stater;

public interface SourceConsumer
    extends Stater, GenericAutoCloseable<IOException>
{
    Map<String, Object> status(final boolean verbose);

    Scheduler scheduler();

    UploaderFactory uploaderFactory();

    AsyncClient producer();

    AsyncClient schedulersClient();

    YtClient yt();

    PrefixedLogger logger();

    ImmutableSourceConsumerConfig config();

    ImmutableWorkersConfig workersConfig();

    HttpHost currentHost();

    void start();
}
