package ru.yandex.search.mail.yt.consumer.alice;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mail.yt.consumer.YtConsumer;
import ru.yandex.search.mail.yt.consumer.config.AliceConfigBuilder;
import ru.yandex.search.mail.yt.consumer.config.ImmutableAliceConfig;
import ru.yandex.search.mail.yt.consumer.config.SourceConsumerBuildContext;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class AliceConsumerBuildContext implements SourceConsumerBuildContext {
    private final ImmutableAliceConfig aliceConfig;

    public AliceConsumerBuildContext(
        final IniConfig config)
        throws ConfigException
    {
        this.aliceConfig = new AliceConfigBuilder(config).build();
    }

    @Override
    public SourceConsumerFactory factory() {
        return SourceConsumerFactory.ALICE;
    }

    @Override
    public AliceSourceConsumer build(
        final YtConsumer ytConsumer)
        throws ConfigException
    {
        return new AliceSourceConsumer(ytConsumer, aliceConfig);
    }

    public ImmutableAliceConfig aliceConfig() {
        return aliceConfig;
    }
}
