package ru.yandex.search.mail.yt.consumer.alice;

import java.io.File;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.mail.yt.consumer.SourceConsumer;
import ru.yandex.search.mail.yt.consumer.scheduler.AbstractScheduler;

public class AliceScheduler extends AbstractScheduler {
    private static final DateTimeFormatter FORMATTER =
        ISODateTimeFormat.dateHourMinuteSecond();
    private static final long DEFAULT_START_TS = 1523336923000L;

    public AliceScheduler(final SourceConsumer consumer)
        throws ConfigException
    {
        super(consumer);
    }

    @Override
    protected long minimalTs() {
        return DEFAULT_START_TS;
    }

    @Override
    protected String extractName(final String name) {
        return new File(name).getName();
    }

    @Override
    protected DateTime accept(final String sourceName) {
        return FORMATTER.parseDateTime(sourceName);
    }
}
