package ru.yandex.search.mail.yt.consumer.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractYtConfigBuilder
    <T extends AbstractYtConfigBuilder<T>>
    implements YtConfig
{
    private HttpHost cluster;
    private String home;
    private String tmp;

    private String token;
    private String account;

    private HttpTargetConfigBuilder ytClient;

    protected AbstractYtConfigBuilder(final YtConfig config) {
        this.cluster(config.cluster());
        this.home(config.home());
        this.tmp(config.tmp());
        this.token(config.token());
        this.account(config.account());
        this.clientConfig(config.clientConfig());
    }

    protected AbstractYtConfigBuilder(
        final IniConfig config,
        final YtConfig defaults)
        throws ConfigException
    {
        this.cluster =
            config.get(
                "cluster",
                defaults.cluster(),
                HttpHostParser.INSTANCE);

        this.account = config.getString("account", defaults.home());
        this.home = config.getString("home", defaults.home());
        this.tmp = config.getString("tmp", defaults.home());
        this.token = config.getString("token", defaults.home());

        IniConfig clientSection = config.sectionOrNull("client");
        if (clientSection != null) {
            this.ytClient =
                new HttpTargetConfigBuilder(
                    clientSection,
                    defaults.clientConfig());
        } else {
            this.ytClient =
                new HttpTargetConfigBuilder(defaults.clientConfig());
        }
    }

    protected abstract T self();

    @Override
    public HttpHost cluster() {
        return cluster;
    }

    public T cluster(final HttpHost cluster) {
        this.cluster = cluster;
        return self();
    }

    @Override
    public String home() {
        return home;
    }

    public T home(final String home) {
        this.home = home;
        return self();
    }

    @Override
    public String tmp() {
        return tmp;
    }

    public T tmp(final String tmp) {
        this.tmp = tmp;
        return self();
    }

    @Override
    public String token() {
        return token;
    }

    public T token(final String token) {
        this.token = token;
        return self();
    }

    @Override
    public String account() {
        return account;
    }

    public T account(final String account) {
        this.account = account;
        return self();
    }

    @Override
    public HttpTargetConfigBuilder clientConfig() {
        return ytClient;
    }

    public T clientConfig(final HttpTargetConfig ytClient) {
        this.ytClient = new HttpTargetConfigBuilder(ytClient);
        return self();
    }
}
