package ru.yandex.search.mail.yt.consumer.config;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.config.HttpTargetConfigBuilder;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public abstract class AbstractYtConsumerConfigBuilder
    <T extends AbstractYtConsumerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements YtConsumerConfig
{
    private static final String POSTFIX = "-consumer";

    private YtConfigBuilder ytConfig;
    private Set<SourceConsumerBuildContext> consumers;
    private Set<HttpHost> schedulersHosts;
    private HttpTargetConfigBuilder schedulerClientConfig;
    private WorkersConfigBuilder workersConfig;

    protected AbstractYtConsumerConfigBuilder(
        final YtConsumerConfig config)
    {
        super(config);

        this.ytConfig(config.ytConfig());
        this.workersConfig(config.workersConfig());
        this.consumers(config.consumers());
    }

    protected AbstractYtConsumerConfigBuilder(
        final IniConfig config,
        final YtConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        this.ytConfig =
            new YtConfigBuilder(config.section("yt"), defaults.ytConfig());
        this.consumers = new LinkedHashSet<>();

        this.consumers = new LinkedHashSet<>();

        for (String name: config.sections().keySet()) {
            if (name.toLowerCase(Locale.ROOT).endsWith(POSTFIX)) {
                IniConfig section = config.section(name);
                SourceConsumerFactory factory =
                    section.getEnum(SourceConsumerFactory.class, "consumer");
                consumers.add(factory.create(section));
            }
        }

        this.schedulersHosts =
            config.get(
                "schedulers",
                new CollectionParser<>(HttpHostParser.INSTANCE, HashSet::new));

        this.schedulerClientConfig =
            new HttpTargetConfigBuilder(config.section("scheduler-client"));
        this.workersConfig =
            new WorkersConfigBuilder(
                config.section("workers"),
                defaults.workersConfig());
    }

    @Override
    public YtConfigBuilder ytConfig() {
        return ytConfig;
    }

    public T ytConfig(
        final YtConfig ytConfig)
    {
        this.ytConfig = new YtConfigBuilder(ytConfig);
        return self();
    }

    @Override
    public Set<SourceConsumerBuildContext> consumers() {
        return consumers;
    }

    public T consumers(final Set<SourceConsumerBuildContext> consumers) {
        this.consumers = new LinkedHashSet<>(consumers);

        return self();
    }

    @Override
    public WorkersConfigBuilder workersConfig() {
        return workersConfig;
    }

    public T workersConfig(final WorkersConfig config) {
        this.workersConfig = new WorkersConfigBuilder(config);
        return self();
    }

    @Override
    public Set<HttpHost> schedulers() {
        return schedulersHosts;
    }

    public Set<HttpHost> schedulersHosts() {
        return schedulersHosts;
    }

    public T schedulersHosts(
        final Set<HttpHost> schedulersHosts)
    {
        this.schedulersHosts = schedulersHosts;
        return self();
    }

    public T schedulerClientConfig(
        final HttpTargetConfig schedulerClientConfig)
    {
        this.schedulerClientConfig =
            new HttpTargetConfigBuilder(schedulerClientConfig);
        return self();
    }

    @Override
    public HttpTargetConfigBuilder schedulerClientConfig() {
        return schedulerClientConfig;
    }
}
