package ru.yandex.search.mail.yt.consumer.config;

import java.io.File;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AliceConfigBuilder
    extends SourceConsumerConfigBuilder
    implements AliceConfig
{
    private File humanNamesFile;

    public AliceConfigBuilder() {
        this(AliceConfigDefaults.INSTANCE);
    }

    public AliceConfigBuilder(final IniConfig config) throws ConfigException {
        this(config, AliceConfigDefaults.INSTANCE);
    }

    public AliceConfigBuilder(
        final IniConfig config,
        final AliceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        this.humanNamesFile =
            config.getInputFile("names-file", defaults.humanNamesFile());
    }

    public AliceConfigBuilder(final AliceConfig config) {
        super(config);

        this.humanNamesFile = config.humanNamesFile();
    }

    public AliceConfigBuilder humanNamesFile(final File fileName) {
        this.humanNamesFile = fileName;
        return this;
    }

    @Override
    public File humanNamesFile() {
        return humanNamesFile;
    }

    @Override
    public ImmutableAliceConfig build() throws ConfigException {
        return new ImmutableAliceConfig(this);
    }
}
