package ru.yandex.search.mail.yt.consumer.config;

import java.util.Collections;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class ImmutableSourceConsumerConfig implements SourceConsumerConfig {
    private final String basePath;
    private final String monitorPath;
    private final String service;
    private final int checkInterval;
    private final int producerPushInterval;
    private final int batchSize;
    private final int splitRowCount;
    private final int lockTimeout;
    private final int keepCompletedCount;
    private final int commitEvery;
    private final SourceConsumerFactory consumer;
    private final ImmutableHttpHostConfig producer;
    private final Set<HttpHost> schedulers;

    public ImmutableSourceConsumerConfig(
        final SourceConsumerConfig config)
        throws ConfigException
    {
        this.basePath = config.basePath();
        this.monitorPath = config.monitorPath();
        this.checkInterval = config.checkInterval();
        this.producerPushInterval = config.producerPushInterval();
        this.batchSize = config.batchSize();
        this.splitRowCount = config.splitRowCount();
        this.consumer = config.consumer();
        this.schedulers = Collections.unmodifiableSet(config.schedulers());
        this.producer = new ImmutableHttpHostConfig(config.producer());

        this.lockTimeout = config.lockTimeout();
        this.service = config.service();
        this.keepCompletedCount = config.keepCompletedCount();
        this.commitEvery = config.commitEvery();
    }

    @Override
    public String basePath() {
        return basePath;
    }

    @Override
    public String monitorPath() {
        return monitorPath;
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    @Override
    public int batchSize() {
        return batchSize;
    }

    @Override
    public int splitRowCount() {
        return splitRowCount;
    }

    @Override
    public SourceConsumerFactory consumer() {
        return consumer;
    }

    @Override
    public Set<HttpHost> schedulers() {
        return schedulers;
    }

    @Override
    public ImmutableHttpHostConfig producer() {
        return producer;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public int lockTimeout() {
        return lockTimeout;
    }

    @Override
    public int keepCompletedCount() {
        return keepCompletedCount;
    }

    @Override
    public int producerPushInterval() {
        return producerPushInterval;
    }

    @Override
    public int commitEvery() {
        return commitEvery;
    }
}
