package ru.yandex.search.mail.yt.consumer.config;

public class ImmutableWorkersConfig implements WorkersConfig {
    private final String todoPath;
    private final String donePath;
    private final String processingPath;
    private final int workers;
    private final int checkInterval;

    public ImmutableWorkersConfig(final WorkersConfig config) {
        this.workers = config.workers();
        this.checkInterval = config.checkInterval();

        this.todoPath = config.todoPath();
        this.processingPath = config.processingPath();
        this.donePath = config.donePath();
    }

    @Override
    public int workers() {
        return workers;
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    @Override
    public String donePath() {
        return donePath;
    }

    @Override
    public String todoPath() {
        return todoPath;
    }

    @Override
    public String processingPath() {
        return processingPath;
    }
}
