package ru.yandex.search.mail.yt.consumer.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableYtConfig implements YtConfig {
    private final HttpHost cluster;
    private final String home;
    private final String tmp;

    private final String token;
    private final String account;

    private final ImmutableHttpTargetConfig clientConfig;

    public ImmutableYtConfig(
        final YtConfig config)
        throws ConfigException
    {
        this.cluster = config.cluster();
        this.home = config.home();
        this.tmp = config.tmp();
        this.token = config.token();
        this.account = config.account();

        this.clientConfig =
            new ImmutableHttpTargetConfig(config.clientConfig());
    }

    @Override
    public HttpHost cluster() {
        return cluster;
    }

    @Override
    public String home() {
        return home;
    }

    @Override
    public String tmp() {
        return tmp;
    }

    @Override
    public String token() {
        return token;
    }

    @Override
    public String account() {
        return account;
    }

    @Override
    public ImmutableHttpTargetConfig clientConfig() {
        return clientConfig;
    }
}
