package ru.yandex.search.mail.yt.consumer.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableYtConsumerConfig
    extends ImmutableHttpProxyConfig
    implements YtConsumerConfig
{
    private final ImmutableYtConfig ytConfig;
    private final ImmutableWorkersConfig workersConfig;
    private final Set<SourceConsumerBuildContext> consumers;
    private final Set<HttpHost> schedulers;
    private final ImmutableHttpTargetConfig schedulerClientConfig;

    public ImmutableYtConsumerConfig(
        final YtConsumerConfig config)
        throws ConfigException
    {
        super(config);

        this.workersConfig = new ImmutableWorkersConfig(config.workersConfig());
        this.ytConfig = new ImmutableYtConfig(config.ytConfig());
        this.consumers = new LinkedHashSet<>(config.consumers());
        this.schedulers = Collections.unmodifiableSet(config.schedulers());
        this.schedulerClientConfig =
            new ImmutableHttpTargetConfig(config.schedulerClientConfig());
    }

    @Override
    public ImmutableYtConfig ytConfig() {
        return ytConfig;
    }

    @Override
    public ImmutableWorkersConfig workersConfig() {
        return workersConfig;
    }

    @Override
    public Set<SourceConsumerBuildContext> consumers() {
        return consumers;
    }

    @Override
    public Set<HttpHost> schedulers() {
        return schedulers;
    }

    @Override
    public ImmutableHttpTargetConfig schedulerClientConfig() {
        return schedulerClientConfig;
    }
}
