package ru.yandex.search.mail.yt.consumer.config;

import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class SourceConsumerConfigBuilder implements SourceConsumerConfig {
    private String basePath;
    private String monitorPath;
    private String service;
    private int checkInterval;
    private int producerPushInterval;
    private int batchSize;
    private int splitRowCount;
    private int lockTimeout;
    private int keepCompletedCount;
    private int commitEvery;
    private SourceConsumerFactory consumer;
    private Set<HttpHost> schedulers;
    private HttpHostConfigBuilder producer;

    public SourceConsumerConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, SourceConsumerConfigDefaults.INSTANCE);
    }

    public SourceConsumerConfigBuilder(
        final IniConfig config,
        final SourceConsumerConfig defaults)
        throws ConfigException
    {
        this.basePath =
            config.getString("workdir", defaults.basePath());
        this.monitorPath =
            config.getString("source", defaults.monitorPath());
        this.checkInterval =
            config.getIntegerDuration(
                "check-interval",
                defaults.checkInterval());
        this.checkInterval =
            config.getInt(
                "producer-push-interval",
                defaults.producerPushInterval());
        this.batchSize =
            config.getInt("batch-size", defaults.batchSize());
        this.commitEvery =
            config.getInt("commit-every", defaults.commitEvery());
        this.splitRowCount =
            config.getInt("split-row-count", defaults.splitRowCount());
        this.keepCompletedCount =
            config.getIntegerDuration(
                "keep-completed-count",
                defaults.keepCompletedCount());
        this.lockTimeout =
            config.getIntegerDuration(
                "lock-timeout",
                defaults.lockTimeout());

        this.consumer =
            config.getEnum(SourceConsumerFactory.class, "consumer");
        this.producer = new HttpHostConfigBuilder(config.section("producer"));
        this.service = config.getString("service", defaults.service());
        this.schedulers =
            config.get(
                "schedulers",
                new CollectionParser<>(
                    HttpHostParser.INSTANCE,
                    LinkedHashSet::new));
    }

    public SourceConsumerConfigBuilder(final SourceConsumerConfig config) {
        this.basePath(config.basePath());
        this.monitorPath(config.monitorPath());
        this.checkInterval(config.checkInterval());
        this.batchSize(config.batchSize());
        this.splitRowCount(config.splitRowCount());
        this.consumer(config.consumer());
        this.schedulers(config.schedulers());
        this.producer(config.producer());
        this.producerPushInterval(config.producerPushInterval());
        this.commitEvery(config.commitEvery());
        this.keepCompletedCount(config.keepCompletedCount());
    }

    @Override
    public String basePath() {
        return basePath;
    }

    public SourceConsumerConfigBuilder basePath(final String basePath) {
        this.basePath = basePath;
        return this;
    }

    @Override
    public String monitorPath() {
        return monitorPath;
    }

    public SourceConsumerConfigBuilder monitorPath(final String monitorPath) {
        this.monitorPath = monitorPath;
        return this;
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    public SourceConsumerConfigBuilder checkInterval(final int checkInterval) {
        this.checkInterval = checkInterval;
        return this;
    }

    @Override
    public int batchSize() {
        return batchSize;
    }

    public SourceConsumerConfigBuilder batchSize(final int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public int splitRowCount() {
        return splitRowCount;
    }

    public SourceConsumerConfigBuilder splitRowCount(final int splitRowCount) {
        this.splitRowCount = splitRowCount;
        return this;
    }

    @Override
    public SourceConsumerFactory consumer() {
        return consumer;
    }

    public SourceConsumerConfigBuilder consumer(
        final SourceConsumerFactory consumer)
    {
        this.consumer = consumer;
        return this;
    }

    @Override
    public Set<HttpHost> schedulers() {
        return schedulers;
    }

    public SourceConsumerConfigBuilder schedulers(
        final Set<HttpHost> schedulers)
    {
        this.schedulers = new LinkedHashSet<>(schedulers);
        return this;
    }

    @Override
    public HttpHostConfigBuilder producer() {
        return producer;
    }

    public SourceConsumerConfigBuilder producer(final HttpHostConfig producer) {
        this.producer = new HttpHostConfigBuilder(producer);
        return this;
    }

    @Override
    public String service() {
        return service;
    }

    public SourceConsumerConfigBuilder service(final String service) {
        this.service = service;
        return this;
    }

    @Override
    public int lockTimeout() {
        return lockTimeout;
    }

    public SourceConsumerConfigBuilder lockTimeout(final int lockTimeout) {
        this.lockTimeout = lockTimeout;
        return this;
    }

    @Override
    public int keepCompletedCount() {
        return keepCompletedCount;
    }

    public SourceConsumerConfigBuilder keepCompletedCount(
        final int keepCompletedCount)
    {
        this.keepCompletedCount = keepCompletedCount;
        return this;
    }

    @Override
    public int producerPushInterval() {
        return producerPushInterval;
    }

    public SourceConsumerConfigBuilder producerPushInterval(
        final int producerPushInterval)
    {
        this.producerPushInterval = producerPushInterval;
        return this;
    }

    public ImmutableSourceConsumerConfig build() throws ConfigException {
        return new ImmutableSourceConsumerConfig(this);
    }

    @Override
    public int commitEvery() {
        return commitEvery;
    }

    public SourceConsumerConfigBuilder commitEvery(final int commitEvery) {
        this.commitEvery = commitEvery;
        return this;
    }
}
