package ru.yandex.search.mail.yt.consumer.config;

import java.util.Collections;
import java.util.Set;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class SourceConsumerConfigDefaults implements SourceConsumerConfig {
    public static final SourceConsumerConfigDefaults INSTANCE =
        new SourceConsumerConfigDefaults();

    private static final int CHECK_INTERVAL = 60000;
    private static final int PRODUCER_PUSH_INTERVAL = 300;
    private static final int BATCH_SIZE = 100;
    private static final int SPLIT_ROW_COUNT = 180000;
    private static final int DEFAULT_LOCK_TIMEOUT = 300000;
    private static final int KEEP_COMPLETED_COUNT = 10;

    @Override
    public String basePath() {
        return null;
    }

    @Override
    public String monitorPath() {
        return null;
    }

    @Override
    public int checkInterval() {
        return CHECK_INTERVAL;
    }

    @Override
    public int batchSize() {
        return BATCH_SIZE;
    }

    @Override
    public int splitRowCount() {
        return SPLIT_ROW_COUNT;
    }

    @Override
    public String service() {
        return null;
    }

    @Override
    public int lockTimeout() {
        return DEFAULT_LOCK_TIMEOUT;
    }

    @Override
    public int keepCompletedCount() {
        return KEEP_COMPLETED_COUNT;
    }

    @Override
    public Set<HttpHost> schedulers() {
        return Collections.emptySet();
    }

    @Override
    public HttpHostConfig producer() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public SourceConsumerFactory consumer() {
        return null;
    }

    @Override
    public int producerPushInterval() {
        return PRODUCER_PUSH_INTERVAL;
    }

    @Override
    public int commitEvery() {
        return -1;
    }
}
