package ru.yandex.search.mail.yt.consumer.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class WorkersConfigBuilder implements WorkersConfig {
    private String donePath;
    private String todoPath;
    private String processingPath;
    private int workers;
    private int checkInterval;

    public WorkersConfigBuilder() {
    }

    public WorkersConfigBuilder(final WorkersConfig config) {
        this.donePath(config.donePath());
        this.todoPath(config.todoPath());
        this.processingPath(config.processingPath());
        this.workers(config.workers());
        this.checkInterval(config.checkInterval());
    }

    public WorkersConfigBuilder(
        final IniConfig config,
        final WorkersConfig defaults)
        throws ConfigException
    {
        this.donePath =
            config.getString("done-path", defaults.donePath());
        this.todoPath =
            config.getString("todo-path", defaults.todoPath());

        this.processingPath =
            config.getString("running-path", defaults.processingPath());
        this.workers = config.getInt("num-workers", defaults.workers());
        this.checkInterval =
            config.getInt("check-interval", defaults.checkInterval());
    }

    @Override
    public String donePath() {
        return donePath;
    }

    public WorkersConfigBuilder donePath(final String donePath) {
        this.donePath = donePath;
        return this;
    }

    @Override
    public String todoPath() {
        return todoPath;
    }

    public WorkersConfigBuilder todoPath(final String todoPath) {
        this.todoPath = todoPath;
        return this;
    }

    @Override
    public String processingPath() {
        return processingPath;
    }

    public WorkersConfigBuilder processingPath(final String processingPath) {
        this.processingPath = processingPath;
        return this;
    }

    @Override
    public int workers() {
        return workers;
    }

    public WorkersConfigBuilder workers(final int workers) {
        this.workers = workers;
        return this;
    }

    @Override
    public int checkInterval() {
        return checkInterval;
    }

    public WorkersConfigBuilder checkInterval(final int checkInterval) {
        this.checkInterval = checkInterval;
        return this;
    }
}
